<?php
/**
 * The template to display Admin notices
 *
 * @package YOKOO
 * @since YOKOO 1.0.64
 */

$yokoo_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$yokoo_skins_args = get_query_var( 'yokoo_skins_notice_args' );

?>
<div class="yokoo_admin_notice yokoo_skins_notice update-nag">
	<?php
	// Theme image
	$yokoo_theme_img = yokoo_get_file_url( 'screenshot.jpg' );
	if ( '' != $yokoo_theme_img ) {
		?>
		<div class="yokoo_notice_image"><img src="<?php echo esc_url( $yokoo_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'yokoo' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="yokoo_notice_title">
		<?php esc_html_e( 'New skins available', 'yokoo' ); ?>
	</h3>
	<?php

	// Description
	$yokoo_total      = $yokoo_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$yokoo_skins_msg  = $yokoo_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $yokoo_total, 'yokoo' ), $yokoo_total ) . '</strong>'
							: '';
	$yokoo_total      = $yokoo_skins_args['free'];
	$yokoo_skins_msg .= $yokoo_total > 0
							? ( ! empty( $yokoo_skins_msg ) ? ' ' . esc_html__( 'and', 'yokoo' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $yokoo_total, 'yokoo' ), $yokoo_total ) . '</strong>'
							: '';
	$yokoo_total      = $yokoo_skins_args['pay'];
	$yokoo_skins_msg .= $yokoo_skins_args['pay'] > 0
							? ( ! empty( $yokoo_skins_msg ) ? ' ' . esc_html__( 'and', 'yokoo' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $yokoo_total, 'yokoo' ), $yokoo_total ) . '</strong>'
							: '';
	?>
	<div class="yokoo_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'yokoo' ), $yokoo_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="yokoo_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $yokoo_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'yokoo' );
			?>
		</a>
		<?php
		// Dismiss
		?>
		<a href="#" data-notice="skins" class="yokoo_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="yokoo_hide_notice_text"><?php esc_html_e( 'Dismiss', 'yokoo' ); ?></span></a>
	</div>
</div>
