<?php
/**
 * The style "classic" of the Events
 *
 * @package ThemeREX Addons
 * @since v1.6.51
 */

$args = get_query_var('trx_addons_args_sc_events');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);

if (!empty($args['slider'])) {
	?><div class="slider-slide swiper-slide"><?php
} else if ($args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'], !empty($args['columns_tablet']) ? $args['columns_tablet'] : '', !empty($args['columns_mobile']) ? $args['columns_mobile'] : '')); ?>"><?php
}
?>
<div class="sc_events_item sc_item_container post_container">

	<div class="sc_events_item_info">

		<div class="sc_events_item_first">
			<h4 class="sc_events_item_title"><a href="<?php echo esc_url(get_permalink()); ?>"><?php the_title(); ?></a></h4>
			<div class="sc_events_item_meta">
				<span class="sc_events_item_meta_item sc_events_item_meta_date"><?php
					$dt = tribe_get_start_date(null, true, 'Y-m-d');
					$dt2 = tribe_get_end_date(null, true, 'Y-m-d');
					echo sprintf( $dt < date('Y-m-d')
									? esc_html__('Started on %1$s to %2$s', 'yokoo')
									: esc_html__('Starting %1$s to %2$s', 'yokoo'),
								'<span class="sc_events_item_date sc_events_item_date_start">' . date_i18n(get_option('date_format'), strtotime($dt)) . '</span>',
								'<span class="sc_events_item_date sc_events_item_date_end">' . date_i18n(get_option('date_format'), strtotime($dt2)) . '</span>'
								);
				?></span>
			</div>
		</div>

		<div class="sc_events_item_second">
			<?php
			if (($excerpt = get_the_excerpt()) != '') {
				?><div class="trx_addons_hover_text"><?php echo esc_html($excerpt); ?></div><?php
			}
			?>
		</div>

		<div class="sc_events_item_third">
			<a href="<?php echo esc_url(get_permalink()); ?>" class="<?php echo esc_attr(apply_filters('trx_addons_filter_sc_item_link_classes', 'sc_button sc_button_simple sc_button_size_small', 'sc_events', $args)); ?>"><?php echo esc_html__('Details', 'yokoo'); ?></a>
		</div>

	</div>

</div><?php
if (!empty($args['slider']) || $args['columns'] > 1) {
	?></div><?php
}