<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

// Page (category, tag, archive, author) title

if ( yokoo_need_page_title() ) {
	yokoo_sc_layouts_showed( 'title', true );
	yokoo_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								yokoo_show_post_meta(
									apply_filters(
										'yokoo_filter_post_meta_args', array(
											'components' => join( ',', yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'counters' ) ) ),
											'seo'        => yokoo_is_on( yokoo_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$yokoo_blog_title           = yokoo_get_blog_title();
							$yokoo_blog_title_text      = '';
							$yokoo_blog_title_class     = '';
							$yokoo_blog_title_link      = '';
							$yokoo_blog_title_link_text = '';
							if ( is_array( $yokoo_blog_title ) ) {
								$yokoo_blog_title_text      = $yokoo_blog_title['text'];
								$yokoo_blog_title_class     = ! empty( $yokoo_blog_title['class'] ) ? ' ' . $yokoo_blog_title['class'] : '';
								$yokoo_blog_title_link      = ! empty( $yokoo_blog_title['link'] ) ? $yokoo_blog_title['link'] : '';
								$yokoo_blog_title_link_text = ! empty( $yokoo_blog_title['link_text'] ) ? $yokoo_blog_title['link_text'] : '';
							} else {
								$yokoo_blog_title_text = $yokoo_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $yokoo_blog_title_class ); ?>">
								<?php
								$yokoo_top_icon = yokoo_get_term_image_small();
								if ( ! empty( $yokoo_top_icon ) ) {
									$yokoo_attr = yokoo_getimagesize( $yokoo_top_icon );
									?>
									<img src="<?php echo esc_url( $yokoo_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'yokoo' ); ?>"
										<?php
										if ( ! empty( $yokoo_attr[3] ) ) {
											yokoo_show_layout( $yokoo_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $yokoo_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $yokoo_blog_title_link ) && ! empty( $yokoo_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $yokoo_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $yokoo_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'yokoo_action_breadcrumbs' );
						$yokoo_breadcrumbs = ob_get_contents();
						ob_end_clean();
						yokoo_show_layout( $yokoo_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
