<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_args = get_query_var( 'yokoo_logo_args' );

// Site logo
$yokoo_logo_type   = isset( $yokoo_args['type'] ) ? $yokoo_args['type'] : '';
$yokoo_logo_image  = yokoo_get_logo_image( $yokoo_logo_type );
$yokoo_logo_text   = yokoo_is_on( yokoo_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$yokoo_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $yokoo_logo_image['logo'] ) || ! empty( $yokoo_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $yokoo_logo_image['logo'] ) ) {
			if ( empty( $yokoo_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $yokoo_logo_image['logo'] ) && $yokoo_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$yokoo_attr = yokoo_getimagesize( $yokoo_logo_image['logo'] );
				echo '<img src="' . esc_url( $yokoo_logo_image['logo'] ) . '"'
						. ( ! empty( $yokoo_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $yokoo_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $yokoo_logo_text ) . '"'
						. ( ! empty( $yokoo_attr[3] ) ? ' ' . wp_kses_data( $yokoo_attr[3] ) : '' )
						. '>';
			}
		} else {
			yokoo_show_layout( yokoo_prepare_macros( $yokoo_logo_text ), '<span class="logo_text">', '</span>' );
			yokoo_show_layout( yokoo_prepare_macros( $yokoo_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
