<?php
/**
 * The template to display default site header
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_header_css   = '';
$yokoo_header_image = get_header_image();
$yokoo_header_video = yokoo_get_header_video();
if ( ! empty( $yokoo_header_image ) && yokoo_trx_addons_featured_image_override( is_singular() || yokoo_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$yokoo_header_image = yokoo_get_current_mode_image( $yokoo_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $yokoo_header_image ) || ! empty( $yokoo_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $yokoo_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $yokoo_header_image ) {
		echo ' ' . esc_attr( yokoo_add_inline_css_class( 'background-image: url(' . esc_url( $yokoo_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( yokoo_is_on( yokoo_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight yokoo-full-height';
	}
	$yokoo_header_scheme = yokoo_get_theme_option( 'header_scheme' );
	if ( ! empty( $yokoo_header_scheme ) && ! yokoo_is_inherit( $yokoo_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $yokoo_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $yokoo_header_video ) ) {
		get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( yokoo_is_on( yokoo_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
