<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package YOKOO
 * @since YOKOO 1.0.06
 */

$yokoo_header_css   = '';
$yokoo_header_image = get_header_image();
$yokoo_header_video = yokoo_get_header_video();
if ( ! empty( $yokoo_header_image ) && yokoo_trx_addons_featured_image_override( is_singular() || yokoo_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$yokoo_header_image = yokoo_get_current_mode_image( $yokoo_header_image );
}

$yokoo_header_id = yokoo_get_custom_header_id();
$yokoo_header_meta = get_post_meta( $yokoo_header_id, 'trx_addons_options', true );
if ( ! empty( $yokoo_header_meta['margin'] ) ) {
	yokoo_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( yokoo_prepare_css_value( $yokoo_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $yokoo_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $yokoo_header_id ) ) ); ?>
				<?php
				echo ! empty( $yokoo_header_image ) || ! empty( $yokoo_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $yokoo_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $yokoo_header_image ) {
					echo ' ' . esc_attr( yokoo_add_inline_css_class( 'background-image: url(' . esc_url( $yokoo_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( yokoo_is_on( yokoo_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight yokoo-full-height';
				}
				$yokoo_header_scheme = yokoo_get_theme_option( 'header_scheme' );
				if ( ! empty( $yokoo_header_scheme ) && ! yokoo_is_inherit( $yokoo_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $yokoo_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $yokoo_header_video ) ) {
		get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'yokoo_action_show_layout', $yokoo_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
