<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package YOKOO
 * @since YOKOO 1.0.10
 */

// Footer sidebar
$yokoo_footer_name    = yokoo_get_theme_option( 'footer_widgets' );
$yokoo_footer_present = ! yokoo_is_off( $yokoo_footer_name ) && is_active_sidebar( $yokoo_footer_name );
if ( $yokoo_footer_present ) {
	yokoo_storage_set( 'current_sidebar', 'footer' );
	$yokoo_footer_wide = yokoo_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $yokoo_footer_name ) ) {
		dynamic_sidebar( $yokoo_footer_name );
	}
	$yokoo_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $yokoo_out ) ) {
		$yokoo_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $yokoo_out );
		$yokoo_need_columns = true;   //or check: strpos($yokoo_out, 'columns_wrap')===false;
		if ( $yokoo_need_columns ) {
			$yokoo_columns = max( 0, (int) yokoo_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $yokoo_columns ) {
				$yokoo_columns = min( 4, max( 1, yokoo_tags_count( $yokoo_out, 'aside' ) ) );
			}
			if ( $yokoo_columns > 1 ) {
				$yokoo_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $yokoo_columns ) . ' widget', $yokoo_out );
			} else {
				$yokoo_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $yokoo_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'yokoo_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $yokoo_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $yokoo_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'yokoo_action_before_sidebar', 'footer' );
				yokoo_show_layout( $yokoo_out );
				do_action( 'yokoo_action_after_sidebar', 'footer' );
				if ( $yokoo_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $yokoo_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'yokoo_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
