<?php
/**
 * The template to display default site footer
 *
 * @package YOKOO
 * @since YOKOO 1.0.10
 */

$yokoo_footer_id = yokoo_get_custom_footer_id();
$yokoo_footer_meta = get_post_meta( $yokoo_footer_id, 'trx_addons_options', true );
if ( ! empty( $yokoo_footer_meta['margin'] ) ) {
	yokoo_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( yokoo_prepare_css_value( $yokoo_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $yokoo_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $yokoo_footer_id ) ) ); ?>
						<?php
						$yokoo_footer_scheme = yokoo_get_theme_option( 'footer_scheme' );
						if ( ! empty( $yokoo_footer_scheme ) && ! yokoo_is_inherit( $yokoo_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $yokoo_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'yokoo_action_show_layout', $yokoo_footer_id );
	?>
</footer><!-- /.footer_wrap -->
