<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package YOKOO
 * @since YOKOO 1.0.50
 */

$yokoo_template_args = get_query_var( 'yokoo_template_args' );
if ( is_array( $yokoo_template_args ) ) {
	$yokoo_columns    = empty( $yokoo_template_args['columns'] ) ? 2 : max( 1, $yokoo_template_args['columns'] );
	$yokoo_blog_style = array( $yokoo_template_args['type'], $yokoo_columns );
} else {
	$yokoo_blog_style = explode( '_', yokoo_get_theme_option( 'blog_style' ) );
	$yokoo_columns    = empty( $yokoo_blog_style[1] ) ? 2 : max( 1, $yokoo_blog_style[1] );
}
$yokoo_blog_id       = yokoo_get_custom_blog_id( join( '_', $yokoo_blog_style ) );
$yokoo_blog_style[0] = str_replace( 'blog-custom-', '', $yokoo_blog_style[0] );
$yokoo_expanded      = ! yokoo_sidebar_present() && yokoo_get_theme_option( 'expand_content' ) == 'expand';
$yokoo_components    = ! empty( $yokoo_template_args['meta_parts'] )
							? ( is_array( $yokoo_template_args['meta_parts'] )
								? join( ',', $yokoo_template_args['meta_parts'] )
								: $yokoo_template_args['meta_parts']
								)
							: yokoo_array_get_keys_by_value( yokoo_get_theme_option( 'meta_parts' ) );
$yokoo_post_format   = get_post_format();
$yokoo_post_format   = empty( $yokoo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $yokoo_post_format );

$yokoo_blog_meta     = yokoo_get_custom_layout_meta( $yokoo_blog_id );
$yokoo_custom_style  = ! empty( $yokoo_blog_meta['scripts_required'] ) ? $yokoo_blog_meta['scripts_required'] : 'none';

if ( ! empty( $yokoo_template_args['slider'] ) || $yokoo_columns > 1 || ! yokoo_is_off( $yokoo_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $yokoo_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( yokoo_is_off( $yokoo_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $yokoo_custom_style ) ) . "-1_{$yokoo_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $yokoo_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $yokoo_columns )
					. ' post_layout_' . esc_attr( $yokoo_blog_style[0] )
					. ' post_layout_' . esc_attr( $yokoo_blog_style[0] ) . '_' . esc_attr( $yokoo_columns )
					. ( ! yokoo_is_off( $yokoo_custom_style )
						? ' post_layout_' . esc_attr( $yokoo_custom_style )
							. ' post_layout_' . esc_attr( $yokoo_custom_style ) . '_' . esc_attr( $yokoo_columns )
						: ''
						)
		);
	yokoo_add_blog_animation( $yokoo_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'yokoo_action_show_layout', $yokoo_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $yokoo_template_args['slider'] ) || $yokoo_columns > 1 || ! yokoo_is_off( $yokoo_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
