<?php
/**
 * Skins support: Main skin file for the skin 'Default'
 *
 * Load scripts and styles,
 * and other operations that affect the appearance and behavior of the theme
 * when the skin is activated
 *
 * @package YOKOO
 * @since YOKOO 1.0.46
 */


// SKIN SETUP
//--------------------------------------------------------------------

// Setup fonts, colors, blog and single styles, etc.
$yokoo_skin_path = yokoo_get_file_dir( yokoo_skins_get_current_skin_dir() . 'skin-setup.php' );
if ( ! empty( $yokoo_skin_path ) ) {
	require_once $yokoo_skin_path;
}

// Skin options
$yokoo_skin_path = yokoo_get_file_dir( yokoo_skins_get_current_skin_dir() . 'skin-options.php' );
if ( ! empty( $yokoo_skin_path ) ) {
	require_once $yokoo_skin_path;
}

// Required plugins
$yokoo_skin_path = yokoo_get_file_dir( yokoo_skins_get_current_skin_dir() . 'skin-plugins.php' );
if ( ! empty( $yokoo_skin_path ) ) {
	require_once $yokoo_skin_path;
}

// Demo import
$yokoo_skin_path = yokoo_get_file_dir( yokoo_skins_get_current_skin_dir() . 'skin-demo-importer.php' );
if ( ! empty( $yokoo_skin_path ) ) {
	require_once $yokoo_skin_path;
}


// TRX_ADDONS SETUP
//--------------------------------------------------------------------

// Filter to add in the required plugins list
// Priority 11 to add new plugins to the end of the list
if ( ! function_exists( 'yokoo_skin_tgmpa_required_plugins' ) ) {
	add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_skin_tgmpa_required_plugins', 11 );
	function yokoo_skin_tgmpa_required_plugins( $list = array() ) {
		// ToDo: Check if plugin is in the 'required_plugins' and add his parameters to the TGMPA-list
		//       Replace 'skin-specific-plugin-slug' to the real slug of the plugin
		if ( yokoo_storage_isset( 'required_plugins', 'skin-specific-plugin-slug' ) ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'skin-specific-plugin-slug', 'title' ),
				'slug'     => 'skin-specific-plugin-slug',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter to add/remove components of ThemeREX Addons when current skin is active
if ( ! function_exists( 'yokoo_skin_trx_addons_default_components' ) ) {
	add_filter('trx_addons_filter_load_options', 'yokoo_skin_trx_addons_default_components', 20);
	function yokoo_skin_trx_addons_default_components($components) {
		// ToDo: Set key value in the array $components to 0 (disable component) or 1 (enable component)
		//---> For example (enable reviews for posts):
		//---> $components['components_components_reviews'] = 1;
		return $components;
	}
}

// Filter to add/remove CPT
if ( ! function_exists( 'yokoo_skin_trx_addons_cpt_list' ) ) {
	add_filter('trx_addons_cpt_list', 'yokoo_skin_trx_addons_cpt_list');
	function yokoo_skin_trx_addons_cpt_list( $list = array() ) {
		// ToDo: Unset CPT slug from list to disable CPT when current skin is active
		//---> For example to disable CPT 'Portfolio':
		//---> unset( $list['portfolio'] );
		return $list;
	}
}

// Filter to add/remove shortcodes
if ( ! function_exists( 'yokoo_skin_trx_addons_sc_list' ) ) {
	add_filter('trx_addons_sc_list', 'yokoo_skin_trx_addons_sc_list');
	function yokoo_skin_trx_addons_sc_list( $list = array() ) {
		// ToDo: Unset shortcode's slug from list to disable shortcode when current skin is active
		//---> For example to disable shortcode 'Action':
		//---> unset( $list['action'] );

		// Also can be used to add/remove/modify shortcodes params
		//---> For example to add new template to the 'Blogger':
		//---> $list['blogger']['templates']['default']['new_template_slug'] = array(
		//--->		'title' => __('Title of the new template', 'yokoo'),
		//--->		'layout' => array(
		//--->			'featured' => array(),
		//--->			'content' => array('meta_categories', 'title', 'excerpt', 'meta', 'readmore')
		//--->		)
		//---> );
		return $list;
	}
}

// Filter to add/remove widgets
if ( ! function_exists( 'yokoo_skin_trx_addons_widgets_list' ) ) {
	add_filter('trx_addons_widgets_list', 'yokoo_skin_trx_addons_widgets_list');
	function yokoo_skin_trx_addons_widgets_list( $list = array() ) {
		// ToDo: Unset widget's slug from list to disable widget when current skin is active
		//---> For example to disable widget 'About Me':
		//---> unset( $list['aboutme'] );
		return $list;
	}
}



// SCRIPTS AND STYLES
//--------------------------------------------------

// Enqueue skin-specific scripts
// Priority 1050 -  before main theme plugins-specific (1100)
if ( ! function_exists( 'yokoo_skin_frontend_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'yokoo_skin_frontend_scripts', 1050 );
	function yokoo_skin_frontend_scripts() {
		$yokoo_url = yokoo_get_file_url( yokoo_skins_get_current_skin_dir() . 'css/style.css' );
		if ( '' != $yokoo_url ) {
			wp_enqueue_style( 'yokoo-skin-' . esc_attr( yokoo_skins_get_current_skin_name() ), $yokoo_url, array(), null );
		}
		$yokoo_url = yokoo_get_file_url( yokoo_skins_get_current_skin_dir() . 'skin.js' );
		if ( '' != $yokoo_url ) {
			wp_enqueue_script( 'yokoo-skin-' . esc_attr( yokoo_skins_get_current_skin_name() ), $yokoo_url, array( 'jquery' ), null, true );
		}
	}
}


// Custom styles
$yokoo_style_path = yokoo_get_file_dir( yokoo_skins_get_current_skin_dir() . 'css/style.php' );
if ( ! empty( $yokoo_style_path ) ) {
	require_once $yokoo_style_path;
}


// Return array with current system info
if ( ! function_exists( 'yokoo_skin_get_sys_info' ) ) {
	add_filter( 'trx_addons_filter_get_sys_info', 'yokoo_skin_get_sys_info' );
	function yokoo_skin_get_sys_info( $arr ) {
		unset($arr['php_max_input_vars']);
		$arr['php_version']['recommended'] = '7.0.0+';
		$arr['php_version']['recommended'] = '7.0.0+';
		return $arr;
	}
}


// Services
if ( ! function_exists( 'yokoo_filter_args_related' ) ) {
	add_filter( 'trx_addons_filter_args_related', 'yokoo_filter_args_related' );
	function yokoo_filter_args_related( $args ) {
		if ($args['template_args_name'] == 'trx_addons_args_sc_services'){
			$args['more_text'] = esc_html__('Read more','yokoo');
		}
		return $args;
	}
}