<?php
// Add plugin-specific vars to the custom CSS
if ( ! function_exists( 'yokoo_elm_add_theme_vars' ) ) {
	add_filter( 'yokoo_filter_add_theme_vars', 'yokoo_elm_add_theme_vars', 10, 2 );
	function yokoo_elm_add_theme_vars( $rez, $vars ) {
		$gaps = array(
					'nogap'    =>  0,
					'narrow'   => 10,
					'default'  => 20,
					'extended' => 50,
					'wide'     => 40,
					'wider'    => 60
					);
		foreach ( $gaps as $n => $m ) {
			if ( substr( $vars['page'], 0, 2 ) != '{{' ) {
				$rez[ "page{$m}" ]     = ( $vars['page'] + $m ) . 'px';
				$rez[ "content{$m}" ]  = ( $vars['page'] - $vars['sidebar_gap'] - $vars['sidebar'] + $m ) . 'px';
				$rez[ "elm_gap_{$n}" ] = "{$m}px";
			} else {
				$rez[ "page{$m}" ]     = "{{ data.page{$m} }}";
				$rez[ "content{$m}" ]  = "{{ data.content{$m} }}";
				$rez[ "elm_gap_{$n}" ] = "{{ data.elm_gap_{$n} }}";
			}
		}
		$rez[ "elm_add_page_margins" ] = $rez[ "elm_gap_extended" ];
		return $rez;
	}
}


// Add theme-specific CSS-animations
if ( ! function_exists( 'yokoo_elm_add_theme_animations' ) ) {
	add_filter( 'elementor/controls/animations/additional_animations', 'yokoo_elm_add_theme_animations' );
	function yokoo_elm_add_theme_animations( $animations ) {

		return array_merge( $animations,
			array(
				esc_html__( 'Theme Specific', 'yokoo' ) => array(
					'yokoo-fadeinup' => esc_html__( 'Yokoo - Fade In Up', 'yokoo' ),
					'yokoo-fadeinright' => esc_html__( 'Yokoo - Fade In Right', 'yokoo' ),
					'yokoo-fadeinleft' => esc_html__( 'Yokoo - Fade In Left', 'yokoo' ),
					'yokoo-fadeindown' => esc_html__( 'Yokoo - Fade In Down', 'yokoo' ),
					'yokoo-fadein' => esc_html__( 'Yokoo - Fade In', 'yokoo' )
				)
			)
		);
	}
}


// Add custom animations
if ( ! function_exists( 'yokoo_elm_add_theme_animations' ) ) {
	add_filter( 'elementor/controls/animations/additional_animations', 'yokoo_elm_add_theme_animations' );
	function yokoo_elm_add_theme_animations( $animations ) {
		return array_merge( $animations, array(
			esc_html__( 'Theme Specific', 'yokoo' ) => array(
				'yokoo-fadeinup' => esc_html__( 'Yokoo - Fade In Up', 'yokoo' ),
				'yokoo-fadeinright' => esc_html__( 'Yokoo - Fade In Right', 'yokoo' ),
				'yokoo-fadeinleft' => esc_html__( 'Yokoo - Fade In Left', 'yokoo' ),
				'yokoo-fadeindown' => esc_html__( 'Yokoo - Fade In Down', 'yokoo' ),
				'yokoo-fadein' => esc_html__( 'Yokoo - Fade In', 'yokoo' )
			)
		) );
	}
}