<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

if ( yokoo_sidebar_present() ) {
	
	$yokoo_sidebar_type = yokoo_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $yokoo_sidebar_type && ! yokoo_is_layouts_available() ) {
		$yokoo_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $yokoo_sidebar_type ) {
		// Default sidebar with widgets
		$yokoo_sidebar_name = yokoo_get_theme_option( 'sidebar_widgets' );
		yokoo_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $yokoo_sidebar_name ) ) {
			dynamic_sidebar( $yokoo_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$yokoo_sidebar_id = yokoo_get_custom_sidebar_id();
		do_action( 'yokoo_action_show_layout', $yokoo_sidebar_id );
	}
	$yokoo_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $yokoo_out ) ) {
		$yokoo_sidebar_position    = yokoo_get_theme_option( 'sidebar_position' );
		$yokoo_sidebar_position_ss = yokoo_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $yokoo_sidebar_position );
			echo ' sidebar_' . esc_attr( $yokoo_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $yokoo_sidebar_type );

			if ( 'float' == $yokoo_sidebar_position_ss ) {
				echo ' sidebar_float';
			}
			$yokoo_sidebar_scheme = yokoo_get_theme_option( 'sidebar_scheme' );
			if ( ! empty( $yokoo_sidebar_scheme ) && ! yokoo_is_inherit( $yokoo_sidebar_scheme ) ) {
				echo ' scheme_' . esc_attr( $yokoo_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="yokoo_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'yokoo_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $yokoo_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$yokoo_title = apply_filters( 'yokoo_filter_sidebar_control_title', 'float' == $yokoo_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'yokoo' ) : '' );
				$yokoo_text  = apply_filters( 'yokoo_filter_sidebar_control_text', 'above' == $yokoo_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'yokoo' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $yokoo_title ); ?>"><?php echo esc_html( $yokoo_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'yokoo_action_before_sidebar', 'sidebar' );
				yokoo_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $yokoo_out ) );
				do_action( 'yokoo_action_after_sidebar', 'sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
			<?php

			do_action( 'yokoo_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div><!-- /.sidebar -->
		<div class="clearfix"></div>
		<?php
	}
}
