<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_revslider_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_revslider_theme_setup9', 9 );
	function yokoo_revslider_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_revslider_tgmpa_required_plugins' ) ) {
	
	function yokoo_revslider_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'revslider' ) && yokoo_storage_get_array( 'required_plugins', 'revslider', 'install' ) !== false && yokoo_is_theme_activated() ) {
			$path = yokoo_get_plugin_source_path( 'plugins/revslider/revslider.zip' );
			if ( ! empty( $path ) || yokoo_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => yokoo_storage_get_array( 'required_plugins', 'revslider', 'title' ),
					'slug'     => 'revslider',
					'source'   => ! empty( $path ) ? $path : 'upload://revslider.zip',
					'version'  => '6.5.5',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( ! function_exists( 'yokoo_exists_revslider' ) ) {
	function yokoo_exists_revslider() {
		return function_exists( 'rev_slider_shortcode' );
	}
}
