<?php
/* Gutenberg support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_gutenberg_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_gutenberg_theme_setup9', 9 );
	function yokoo_gutenberg_theme_setup9() {

		// Add wide and full blocks support
		add_theme_support( 'align-wide' );

		// Add editor styles to backend
		add_theme_support( 'editor-styles' );
		if ( yokoo_exists_gutenberg() ) {
			if ( ! yokoo_get_theme_setting( 'gutenberg_add_context' ) ) {				
				add_editor_style( array(
					yokoo_get_file_url( 'css/font-icons/css/fontello.css' ),
					yokoo_get_file_url( 'plugins/gutenberg/gutenberg-preview.css' )
					)
				);
			}
		} else {
			add_editor_style( yokoo_get_file_url( 'css/editor-style.css' ) );
		}

		if ( yokoo_exists_gutenberg() ) {
			add_action( 'wp_enqueue_scripts', 'yokoo_gutenberg_frontend_scripts', 1100 );
			add_action( 'wp_enqueue_scripts', 'yokoo_gutenberg_responsive_styles', 2000 );
			add_filter( 'yokoo_filter_merge_styles', 'yokoo_gutenberg_merge_styles' );
			add_filter( 'yokoo_filter_merge_styles_responsive', 'yokoo_gutenberg_merge_styles_responsive' );
		}
		add_action( 'enqueue_block_editor_assets', 'yokoo_gutenberg_editor_scripts' );
		add_filter( 'yokoo_filter_localize_script_admin',	'yokoo_gutenberg_localize_script');
		add_action( 'after_setup_theme', 'yokoo_gutenberg_add_editor_colors' );
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_gutenberg_tgmpa_required_plugins' );
			add_filter( 'yokoo_filter_theme_plugins', 'yokoo_gutenberg_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_gutenberg_tgmpa_required_plugins' ) ) {
	
	function yokoo_gutenberg_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'gutenberg' ) ) {
			if ( yokoo_storage_get_array( 'required_plugins', 'gutenberg', 'install' ) !== false && version_compare( get_bloginfo( 'version' ), '5.0', '<' ) ) {
				$list[] = array(
					'name'     => yokoo_storage_get_array( 'required_plugins', 'gutenberg', 'title' ),
					'slug'     => 'gutenberg',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'yokoo_gutenberg_theme_plugins' ) ) {
	
	function yokoo_gutenberg_theme_plugins( $list = array() ) {
		$group = ! empty( $list['gutenberg']['group'] )
					? $list['gutenberg']['group']
					: yokoo_storage_get_array( 'required_plugins', 'gutenberg', 'group' ); 
		foreach ( $list as $k => $v ) {
			if ( in_array( $k, array( 'coblocks', 'kadence-blocks' ) ) ) {
				if ( empty( $v['group'] ) ) {
					$list[ $k ]['group'] = $group;
				}
				if ( empty( $v['logo'] ) ) {
					$logo = yokoo_get_file_url( "plugins/gutenberg/{$k}.png" );
					$list[ $k ]['logo'] = empty( $logo )
											? ( ! empty( $list['gutenberg']['logo'] )
													? ( strpos( $list['gutenberg']['logo'], '//' ) !== false
														? $list['gutenberg']['logo']
														: yokoo_get_file_url( "plugins/gutenberg/{$list['gutenberg']['logo']}" )
														)
												: ''
												)
											: $logo;
				}
			}
		}
		return $list;
	}
}


// Check if Gutenberg is installed and activated
if ( ! function_exists( 'yokoo_exists_gutenberg' ) ) {
	function yokoo_exists_gutenberg() {
		return function_exists( 'register_block_type' );
	}
}

// Return true if Gutenberg exists and current mode is preview
if ( ! function_exists( 'yokoo_gutenberg_is_preview' ) ) {
	function yokoo_gutenberg_is_preview() {
		return yokoo_exists_gutenberg() 
				&& (
					yokoo_gutenberg_is_block_render_action()
					||
					yokoo_is_post_edit()
					);
	}
}

// Return true if current mode is "Block render"
if ( ! function_exists( 'yokoo_gutenberg_is_block_render_action' ) ) {
	function yokoo_gutenberg_is_block_render_action() {
		return yokoo_exists_gutenberg() 
				&& yokoo_check_url( 'block-renderer' ) && ! empty( $_GET['context'] ) && 'edit' == $_GET['context'];
	}
}

// Return true if content built with "Gutenberg"
if ( ! function_exists( 'yokoo_gutenberg_is_content_built' ) ) {
	function yokoo_gutenberg_is_content_built($content) {
		return yokoo_exists_gutenberg() 
				&& has_blocks( $content );	// This condition is equval to: strpos($content, '<!-- wp:') !== false;
	}
}

// Enqueue styles for frontend
if ( ! function_exists( 'yokoo_gutenberg_frontend_scripts' ) ) {
	
	function yokoo_gutenberg_frontend_scripts() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/gutenberg/gutenberg.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-gutenberg', $yokoo_url, array(), null );
			}
		}
	}
}

// Enqueue responsive styles for frontend
if ( ! function_exists( 'yokoo_gutenberg_responsive_styles' ) ) {
	
	function yokoo_gutenberg_responsive_styles() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/gutenberg/gutenberg-responsive.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-gutenberg-responsive', $yokoo_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'yokoo_gutenberg_merge_styles' ) ) {
	
	function yokoo_gutenberg_merge_styles( $list ) {
		$list[] = 'plugins/gutenberg/gutenberg.css';
		return $list;
	}
}

// Merge responsive styles
if ( ! function_exists( 'yokoo_gutenberg_merge_styles_responsive' ) ) {
	
	function yokoo_gutenberg_merge_styles_responsive( $list ) {
		$list[] = 'plugins/gutenberg/gutenberg-responsive.css';
		return $list;
	}
}


// Load required styles and scripts for Gutenberg Editor mode
if ( ! function_exists( 'yokoo_gutenberg_editor_scripts' ) ) {
	
	function yokoo_gutenberg_editor_scripts() {
		yokoo_admin_scripts(true);
		yokoo_admin_localize_scripts();
		// Editor styles
		wp_enqueue_style( 'yokoo-gutenberg-editor', yokoo_get_file_url( 'plugins/gutenberg/gutenberg-editor.css' ), array(), null );
		if ( yokoo_get_theme_setting( 'gutenberg_add_context' ) ) {
			wp_enqueue_style( 'yokoo-gutenberg-preview', yokoo_get_file_url( 'plugins/gutenberg/gutenberg-preview.css' ), array(), null );
		}
		// Editor scripts
		wp_enqueue_script( 'yokoo-gutenberg-preview', yokoo_get_file_url( 'plugins/gutenberg/gutenberg-preview.js' ), array( 'jquery' ), null, true );
	}
}

// Add plugin's specific variables to the scripts
if ( ! function_exists( 'yokoo_gutenberg_localize_script' ) ) {
	
	function yokoo_gutenberg_localize_script( $arr ) {
		// Color scheme
		$arr['color_scheme'] = yokoo_get_theme_option( 'color_scheme' );
		// Sidebar position on the single posts
		$arr['sidebar_position'] = 'inherit';
		$arr['expand_content']   = 'inherit';
		$post_type               = 'post';
		$post_id                 = yokoo_get_value_gpc( 'post' );
		if ( yokoo_gutenberg_is_preview() && ! empty( $post_id ) ) {
			$post_type = yokoo_get_edited_post_type();
			$post_slug = str_replace( 'cpt_', '', $post_type );
			$meta = get_post_meta( $post_id, 'yokoo_options', true );
			if ( 'page' != $post_type && ! empty( $meta['sidebar_position_single'] ) ) {
				$arr['sidebar_position'] = $meta['sidebar_position_single'];
			} elseif ( 'page' == $post_type && ! empty( $meta['sidebar_position'] ) ) {
				$arr['sidebar_position'] = $meta['sidebar_position'];
			}
			if ( 'page' != $post_type && ! empty( $meta['expand_content_single'] ) ) {
				$arr['expand_content'] = $meta['expand_content_single'];
			} elseif ( 'page' == $post_type && ! empty( $meta['expand_content'] ) ) {
				$arr['expand_content'] = $meta['expand_content'];
			}
		}
		if ( 'inherit' == $arr['sidebar_position'] ) {
			if ( 'post' == $post_type ) {
				$arr['sidebar_position'] = yokoo_get_theme_option( 'sidebar_position_single' );
				if ( 'inherit' == $arr['sidebar_position'] ) {
					$arr['sidebar_position'] = yokoo_get_theme_option( 'sidebar_position_blog' );
				}
			} else if ( 'page' != $post_type && yokoo_check_theme_option( 'sidebar_position_single_' . sanitize_title( $post_slug ) ) ) {
				$arr['sidebar_position'] = yokoo_get_theme_option( 'sidebar_position_single_' . sanitize_title( $post_slug ) );
				if ( 'inherit' == $arr['sidebar_position'] && yokoo_check_theme_option( 'sidebar_position_' . sanitize_title( $post_slug ) ) ) {
					$arr['sidebar_position'] = yokoo_get_theme_option( 'sidebar_position_' . sanitize_title( $post_slug ) );
				}
			}
			if ( 'inherit' == $arr['sidebar_position'] ) {
				$arr['sidebar_position'] = yokoo_get_theme_option( 'sidebar_position' );
			}
		}
		if ( 'inherit' == $arr['expand_content'] ) {
			if ( 'post' == $post_type ) {
				$arr['expand_content'] = yokoo_get_theme_option( 'expand_content_single' );
				if ( 'inherit' == $arr['expand_content'] ) {
					$arr['expand_content'] = yokoo_get_theme_option( 'expand_content_blog' );
				}
			} else if ( 'page' != $post_type && yokoo_check_theme_option( 'expand_content_single_' . sanitize_title( $post_slug ) ) ) {
				$arr['expand_content'] = yokoo_get_theme_option( 'expand_content_single_' . sanitize_title( $post_slug ) );
				if ( 'inherit' == $arr['expand_content'] && yokoo_check_theme_option( 'expand_content_' . sanitize_title( $post_slug ) ) ) {
					$arr['expand_content'] = yokoo_get_theme_option( 'expand_content_' . sanitize_title( $post_slug ) );
				}
			}
			if ( 'inherit' == $arr['expand_content'] ) {
				$arr['expand_content'] = yokoo_get_theme_option( 'expand_content' );
			}
		}
		return $arr;
	}
}

// Save CSS with custom colors and fonts to the gutenberg-editor-style.css
if ( ! function_exists( 'yokoo_gutenberg_save_css' ) ) {
	add_action( 'yokoo_action_save_options', 'yokoo_gutenberg_save_css', 30 );
	add_action( 'trx_addons_action_save_options', 'yokoo_gutenberg_save_css', 30 );
	function yokoo_gutenberg_save_css() {

		$msg = '/* ' . esc_html__( "ATTENTION! This file was generated automatically! Don't change it!!!", 'yokoo' )
				. "\n----------------------------------------------------------------------- */\n";

		// Get main styles
		$css = apply_filters( 'yokoo_filter_gutenberg_get_styles', yokoo_fgc( yokoo_get_file_dir( 'style.css' ) ) );

		// Append supported plugins styles
		$css .= yokoo_fgc( yokoo_get_file_dir( 'css/__plugins.css' ) );

		// Append theme-vars styles
		$css .= yokoo_customizer_get_css();

		// Append responsive styles
		$css .= apply_filters( 'yokoo_filter_gutenberg_get_styles_responsive', yokoo_fgc( yokoo_get_file_dir( 'css/__responsive.css' ) ) );

		// Add context class to each selector
		if ( yokoo_get_theme_setting( 'gutenberg_add_context' ) && function_exists( 'trx_addons_css_add_context' ) ) {
			$css = trx_addons_css_add_context(
						$css,
						array(
							'context' => '.edit-post-visual-editor ',
							'context_self' => array( 'html', 'body', '.edit-post-visual-editor' )
							)
					);
		} else {
			$css = apply_filters( 'yokoo_filter_prepare_css', $css );
		}

		// Save styles to the file
		yokoo_fpc( yokoo_get_file_dir( 'plugins/gutenberg/gutenberg-preview.css' ), $msg . $css );
	}
}


// Add theme-specific colors to the Gutenberg color picker
if ( ! function_exists( 'yokoo_gutenberg_add_editor_colors' ) ) {
	//Hamdler of the add_action( 'after_setup_theme', 'yokoo_gutenberg_add_editor_colors' );
	function yokoo_gutenberg_add_editor_colors() {
		$scheme = yokoo_get_scheme_colors();
		$groups = yokoo_storage_get( 'scheme_color_groups' );
		$names  = yokoo_storage_get( 'scheme_color_names' );
		$colors = array();
		foreach( $groups as $g => $group ) {
			foreach( $names as $n => $name ) {
				$c = 'main' == $g ? ( 'text' == $n ? 'text_color' : $n ) : $g . '_' . str_replace( 'text_', '', $n );
				if ( isset( $scheme[ $c ] ) ) {
					$colors[] = array(
						'name'  => ( 'main' == $g ? '' : $group['title'] . ' ' ) . $name['title'],
						'slug'  => $c,
						'color' => $scheme[ $c ]
					);
				}
			}
			// Add only one group of colors
			// Delete next condition (or add false && to them) to add all groups
			if ( 'main' == $g ) {
				break;
			}
		}
		add_theme_support( 'editor-color-palette', $colors );
	}
}

// Add plugin-specific colors and fonts to the custom CSS
if ( yokoo_exists_gutenberg() ) {
	require_once yokoo_get_file_dir( 'plugins/gutenberg/gutenberg-style.php' );
}
