<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_essential_grid_theme_setup9', 9 );
	function yokoo_essential_grid_theme_setup9() {
		if ( yokoo_exists_essential_grid() ) {
			add_action( 'wp_enqueue_scripts', 'yokoo_essential_grid_frontend_scripts', 1100 );
			add_filter( 'yokoo_filter_merge_styles', 'yokoo_essential_grid_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_essential_grid_tgmpa_required_plugins' ) ) {
	
	function yokoo_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'essential-grid' ) && yokoo_storage_get_array( 'required_plugins', 'essential-grid', 'install' ) !== false && yokoo_is_theme_activated() ) {
			$path = yokoo_get_plugin_source_path( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || yokoo_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => yokoo_storage_get_array( 'required_plugins', 'essential-grid', 'title' ),
					'slug'     => 'essential-grid',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'version'  => '3.0.12',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'yokoo_exists_essential_grid' ) ) {
	function yokoo_exists_essential_grid() {
		return defined( 'EG_PLUGIN_PATH' ) || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Enqueue styles for frontend
if ( ! function_exists( 'yokoo_essential_grid_frontend_scripts' ) ) {
	
	function yokoo_essential_grid_frontend_scripts() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/essential-grid/essential-grid.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-essential-grid', $yokoo_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'yokoo_essential_grid_merge_styles' ) ) {
	
	function yokoo_essential_grid_merge_styles( $list ) {
		$list[] = 'plugins/essential-grid/essential-grid.css';
		return $list;
	}
}

