<?php
/* Elegro Crypto Payment support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_elegro_payment_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_elegro_payment_theme_setup9', 9 );
	function yokoo_elegro_payment_theme_setup9() {
		if ( yokoo_exists_elegro_payment() ) {
			add_action( 'wp_enqueue_scripts', 'yokoo_elegro_payment_frontend_scripts', 1100 );
			add_filter( 'yokoo_filter_merge_styles', 'yokoo_elegro_payment_merge_styles' );
		}
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_elegro_payment_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_elegro_payment_tgmpa_required_plugins' ) ) {
	
	function yokoo_elegro_payment_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'woocommerce' ) && yokoo_storage_isset( 'required_plugins', 'elegro-payment' ) && yokoo_storage_get_array( 'required_plugins', 'elegro-payment', 'install' ) !== false ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'elegro-payment', 'title' ),
				'slug'     => 'elegro-payment',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if this plugin installed and activated
if ( ! function_exists( 'yokoo_exists_elegro_payment' ) ) {
	function yokoo_exists_elegro_payment() {
		return class_exists( 'WC_Elegro_Payment' );
	}
}


// Enqueue styles for frontend
if ( ! function_exists( 'yokoo_elegro_payment_frontend_scripts' ) ) {
	
	function yokoo_elegro_payment_frontend_scripts() {
		if ( yokoo_is_on( yokoo_get_theme_option( 'debug_mode' ) ) ) {
			$yokoo_url = yokoo_get_file_url( 'plugins/elegro-payment/elegro-payment.css' );
			if ( '' != $yokoo_url ) {
				wp_enqueue_style( 'yokoo-elegro-payment', $yokoo_url, array(), null );
			}
		}
	}
}


// Merge custom styles
if ( ! function_exists( 'yokoo_elegro_payment_merge_styles' ) ) {
	
	function yokoo_elegro_payment_merge_styles( $list ) {
		$list[] = 'plugins/elegro-payment/elegro-payment.css';
		return $list;
	}
}
