<?php
/* Date Time Picker Field support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'yokoo_date_time_picker_field_feed_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'yokoo_date_time_picker_field_theme_setup9', 9 );
	function yokoo_date_time_picker_field_theme_setup9() {
		if ( is_admin() ) {
			add_filter( 'yokoo_filter_tgmpa_required_plugins', 'yokoo_date_time_picker_field_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'yokoo_date_time_picker_field_tgmpa_required_plugins' ) ) {
	
	function yokoo_date_time_picker_field_tgmpa_required_plugins( $list = array() ) {
		if ( yokoo_storage_isset( 'required_plugins', 'date-time-picker-field' ) ) {
			$list[] = array(
				'name'     => yokoo_storage_get_array( 'required_plugins', 'date-time-picker-field', 'title' ),
				'slug'     => 'date-time-picker-field',
				'required' => false,
			);
		}
		return $list;
	}
}
// Check if this plugin installed and activated
if ( ! function_exists( 'yokoo_exists_date_time_picker_field' ) ) {
	function yokoo_exists_date_time_picker_field() {
		return class_exists( 'CMoreira\\Plugins\\DateTimePicker\\Init' );
	}
}


// Set plugin's specific importer options
if ( !function_exists( 'yokoo_date_time_picker_field_importer_set_options' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_options',    'yokoo_date_time_picker_field_importer_set_options' );
    function yokoo_date_time_picker_field_importer_set_options($options=array()) {   
        if ( yokoo_exists_date_time_picker_field() && in_array('date-time-picker-field', $options['required_plugins']) ) {
            $options['additional_options'][]    = 'dtpicker';                    // Add slugs to export options for this plugin
        }
        return $options;
    }
}
