<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package YOKOO
 * @since YOKOO 1.0
 */

$yokoo_template = apply_filters( 'yokoo_filter_get_template_part', yokoo_blog_archive_get_template() );

if ( ! empty( $yokoo_template ) && 'index' != $yokoo_template ) {

	get_template_part( $yokoo_template );

} else {

	yokoo_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$yokoo_stickies  = is_home() ? get_option( 'sticky_posts' ) : false;
		$yokoo_post_type = yokoo_get_theme_option( 'post_type' );
		$yokoo_args      = array(
								'blog_style'     => yokoo_get_theme_option( 'blog_style' ),
								'post_type'      => $yokoo_post_type,
								'taxonomy'       => yokoo_get_post_type_taxonomy( $yokoo_post_type ),
								'parent_cat'     => yokoo_get_theme_option( 'parent_cat' ),
								'posts_per_page' => yokoo_get_theme_option( 'posts_per_page' ),
								'sticky'         => yokoo_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $yokoo_stickies )
															&& count( $yokoo_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		yokoo_blog_archive_start();

		do_action( 'yokoo_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'yokoo_action_before_page_author' );
			get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'yokoo_action_after_page_author' );
		}

		if ( yokoo_get_theme_option( 'show_filters' ) ) {
			do_action( 'yokoo_action_before_page_filters' );
			yokoo_show_filters( $yokoo_args );
			do_action( 'yokoo_action_after_page_filters' );
		} else {
			do_action( 'yokoo_action_before_page_posts' );
			yokoo_show_posts( array_merge( $yokoo_args, array( 'cat' => $yokoo_args['parent_cat'] ) ) );
			do_action( 'yokoo_action_after_page_posts' );
		}

		do_action( 'yokoo_action_blog_archive_end' );

		yokoo_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'yokoo_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
