<div class="front_page_section front_page_section_testimonials<?php
	$yokoo_scheme = yokoo_get_theme_option( 'front_page_testimonials_scheme' );
	if ( ! empty( $yokoo_scheme ) && ! yokoo_is_inherit( $yokoo_scheme ) ) {
		echo ' scheme_' . esc_attr( $yokoo_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( yokoo_get_theme_option( 'front_page_testimonials_paddings' ) );
	if ( yokoo_get_theme_option( 'front_page_testimonials_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$yokoo_css      = '';
		$yokoo_bg_image = yokoo_get_theme_option( 'front_page_testimonials_bg_image' );
		if ( ! empty( $yokoo_bg_image ) ) {
			$yokoo_css .= 'background-image: url(' . esc_url( yokoo_get_attachment_url( $yokoo_bg_image ) ) . ');';
		}
		if ( ! empty( $yokoo_css ) ) {
			echo ' style="' . esc_attr( $yokoo_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$yokoo_anchor_icon = yokoo_get_theme_option( 'front_page_testimonials_anchor_icon' );
	$yokoo_anchor_text = yokoo_get_theme_option( 'front_page_testimonials_anchor_text' );
if ( ( ! empty( $yokoo_anchor_icon ) || ! empty( $yokoo_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_testimonials"'
									. ( ! empty( $yokoo_anchor_icon ) ? ' icon="' . esc_attr( $yokoo_anchor_icon ) . '"' : '' )
									. ( ! empty( $yokoo_anchor_text ) ? ' title="' . esc_attr( $yokoo_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_testimonials_inner
	<?php
	if ( yokoo_get_theme_option( 'front_page_testimonials_fullheight' ) ) {
		echo ' yokoo-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$yokoo_css      = '';
			$yokoo_bg_mask  = yokoo_get_theme_option( 'front_page_testimonials_bg_mask' );
			$yokoo_bg_color_type = yokoo_get_theme_option( 'front_page_testimonials_bg_color_type' );
			if ( 'custom' == $yokoo_bg_color_type ) {
				$yokoo_bg_color = yokoo_get_theme_option( 'front_page_testimonials_bg_color' );
			} elseif ( 'scheme_bg_color' == $yokoo_bg_color_type ) {
				$yokoo_bg_color = yokoo_get_scheme_color( 'bg_color', $yokoo_scheme );
			} else {
				$yokoo_bg_color = '';
			}
			if ( ! empty( $yokoo_bg_color ) && $yokoo_bg_mask > 0 ) {
				$yokoo_css .= 'background-color: ' . esc_attr(
					1 == $yokoo_bg_mask ? $yokoo_bg_color : yokoo_hex2rgba( $yokoo_bg_color, $yokoo_bg_mask )
				) . ';';
			}
			if ( ! empty( $yokoo_css ) ) {
				echo ' style="' . esc_attr( $yokoo_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_testimonials_content_wrap content_wrap">
			<?php
			// Caption
			$yokoo_caption = yokoo_get_theme_option( 'front_page_testimonials_caption' );
			if ( ! empty( $yokoo_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_testimonials_caption front_page_block_<?php echo ! empty( $yokoo_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $yokoo_caption, 'yokoo_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$yokoo_description = yokoo_get_theme_option( 'front_page_testimonials_description' );
			if ( ! empty( $yokoo_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_testimonials_description front_page_block_<?php echo ! empty( $yokoo_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $yokoo_description ), 'yokoo_kses_content' ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_testimonials_output">
				<?php
				if ( is_active_sidebar( 'front_page_testimonials_widgets' ) ) {
					dynamic_sidebar( 'front_page_testimonials_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! yokoo_exists_trx_addons() ) {
						yokoo_customizer_need_trx_addons_message();
					} else {
						yokoo_customizer_need_widgets_message( 'front_page_testimonials_caption', 'ThemeREX Addons - Testimonials' );
					}
				}
				?>
			</div>
		</div>
	</div>
</div>
